/*================================================================================================================*/
// THESE ARE THE INFORMATIONS OF THE MAP:
/*================================================================================================================*/
// TEMPLATE CREATED BY DANY:
// NOVEMBRE 2006:
// TEXAS BY ENSEMBLE:
// OCTOBER 2003:
/*================================================================================================================*/
// ********************************* MAIN ENTRY POINT FOR RANDOM MAP SCRIPT: ************************************ //
/*================================================================================================================*/
include "mercenaries.xs";
void main(void)
{
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",0.01);
/*================================================================================================================*/
// ****************************************** PICKS THE MAP SIZE: *********************************************** //
/*================================================================================================================*/
	  // int playerTiles=10000;
	     int playerTiles=25000;
	
	  // if (cNumberNonGaiaPlayers >4)
	  //	playerTiles = 9500;

	  int size=2.0*sqrt(cNumberNonGaiaPlayers*playerTiles);
	  rmEchoInfo("Map size="+size+"m x "+size+"m");
	  rmSetMapSize(size, size);
/*================================================================================================================*/
// *************************************** DEFINE THE MAP PARAMETERS: ******************************************* //
/*================================================================================================================*/	
	// PICKS A DEFAULT WATER HEIGHT:
	rmSetSeaLevel(0.0);

    // PICKS THE DEFAULT MAP ELEVATION:
	rmSetMapElevationParameters(cElevTurbulence, 0.02, 7, 0.5, 8.0);
	
	// PICKS THE DEFAULT WATER:
	// NONE:
	
	// PICKS THE DEFAULT TERRAIN:
	rmSetBaseTerrainMix("great plains drygrass");
	rmTerrainInitialize("yukon\ground1_yuk", 5);
	
	// PICKS THE MAP TYPE:
	rmSetMapType("greatPlains");
	rmSetMapType("land");
	rmSetMapType("grass");
	
	// PICKS THE LIGHTING:
	rmSetLightingSet("great plains");
	
	// PICKS THE WORLD CIRCLE CONSTRAINT:
	rmSetWorldCircleConstraint(true);

	// PICKS THE MERCS:
	chooseMercs();
/*================================================================================================================*/	  
/*================================================================================================================*/
// ************************ DEFINE SOME CLASSES. THESE ARE USED LATER FOR CONSTRAINTS: ************************** //
/*================================================================================================================*/      
	  int classPlayer=rmDefineClass("player");
      rmDefineClass("startingUnit");
	  rmDefineClass("classForest");
	  rmDefineClass("classCliff");
	  rmDefineClass("ClassNugget");
	  rmDefineClass("natives");
	  rmDefineClass("importantItem");
	  rmDefineClass("classSocket");
	  	  
// ****************************************** DEFINE THE CONSTRAINTS: ******************************************* //
// ************************ THESE ARE USED TO HAVE OBJECTS AND AREAS AVOID EACH OTHERS: ************************* //
/*================================================================================================================*/
      // MAP EDGE CONSTRAINT:
	  int playerEdgeConstraint=rmCreateBoxConstraint("player edge of map", rmXTilesToFraction(10), rmZTilesToFraction(10), 1.0-rmXTilesToFraction(10), 1.0-rmZTilesToFraction(10), 0.01);
      	  
	  // CARDINAL DIRECTIONS FOR EACH 90 DEGREES:
      int Northward=rmCreatePieConstraint("northMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(0), rmDegreesToRadians(90));
      int Southward=rmCreatePieConstraint("southMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(180), rmDegreesToRadians(270));
      int Eastward=rmCreatePieConstraint("eastMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(90), rmDegreesToRadians(180));
      int Westward=rmCreatePieConstraint("westMapConstraint", 0.5, 0.5, 0, rmZFractionToMeters(0.5), rmDegreesToRadians(270), rmDegreesToRadians(360));
  	  
	  // CREATE BOX CONSTRAINT:
	  int Westconstraint = rmCreateBoxConstraint("stay in East Box", 0, 1.0, 0.4, 0.6); 
	  int Eastconstraint = rmCreateBoxConstraint("stay in West Box", 1.0, 0.0, 0.6, 0.4); 
	   
      // PLAYER CONSTRAINTS:
      int playerConstraint=rmCreateClassDistanceConstraint("stay away from players", classPlayer, 15.0);
      	  
	  // STARTING AVOIDANCE:
      int avoidStartingUnits=rmCreateClassDistanceConstraint("objects avoid starting units", rmClassID("startingUnit"), 30.0);
      int avoidStartingUnitsSmall=rmCreateClassDistanceConstraint("objects avoid starting units small", rmClassID("startingUnit"), 5.0);
      int avoidStartingUnitsLarge=rmCreateClassDistanceConstraint("objects avoid starting units large", rmClassID("startingUnit"), 50.0);
  	  	  
	  // SHIPS VS. SHIPS:
      int shipVsShip=rmCreateTypeDistanceConstraint("ships avoid ship", "ship", 5.0);
	  
	  // FLAG AVOIDANCE:
	  int flagLand = rmCreateTerrainDistanceConstraint("flag vs land", "land", true, 18.0);
	  int flagVsFlag = rmCreateTypeDistanceConstraint("flag avoid same", "HomeCityWaterSpawnFlag", 22); 
	  int flagEdgeConstraint = rmCreatePieConstraint("flags away from edge of map", 0.5, 0.5, rmGetMapXSize()-20, rmGetMapXSize()-10, 0, 0, 0);
      	  
	  // SEAFOOD AVOIDANCE:
	  //int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "fish", 18.0);
      int whaleVsWhaleID=rmCreateTypeDistanceConstraint("whale v whale", "beluga", 15.0);
      //int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);
      int whaleLand = rmCreateTerrainDistanceConstraint("whale v. land", "land", true, 15.0);
      
      // NATIVES AVOIDANCE:
	  int avoidNatives=rmCreateClassDistanceConstraint("avoid natives", rmClassID("natives"), 15.0);
	  int nativesAvoidNatives=rmCreateClassDistanceConstraint("natives avoids natives", rmClassID("natives"), 45);
	  
	  // COIN AVOIDANCE:
	  int avoidCoin=rmCreateTypeDistanceConstraint("avoid coin", "mine", 12.0);
      int coinAvoidCoin=rmCreateTypeDistanceConstraint("coin avoids coin", "mine", 40.0);
	  
	  // FRUITS AVOIDANCE:
	  int avoidFruits=rmCreateTypeDistanceConstraint("stuffs avoids berries", "berrybush", 12.0);
	  int fruitsAvoidFruits=rmCreateTypeDistanceConstraint("berries avoids berries", "berrybush", 80.0);
	  
	  // NUGGET AVOIDANCE:
	  int avoidNugget=rmCreateClassDistanceConstraint("stuff avoid nugget", rmClassID("classNugget"), 10.0);
	  int nuggetAvoidNugget=rmCreateClassDistanceConstraint("nugget avoids nugget", rmClassID("ClassNugget"), 40.0);
	  
	  // BISON AVOIDANCE:
	  int avoidBison=rmCreateTypeDistanceConstraint("stuff avoids food", "bison", 40.0);
	  int bisonAvoidBison=rmCreateTypeDistanceConstraint("bison avoids food", "bison", 40.0);
      	  
	  // SHEEP AVOIDANCE:
	  int avoidSheep=rmCreateTypeDistanceConstraint("stuff avoid sheep", "sheep", 12.0);
	  int sheepAvoidSheep=rmCreateTypeDistanceConstraint("sheep avoid sheep", "sheep", 40.0);
	  
	  // DEER AVOIDANCE:
	  int avoidDeer=rmCreateTypeDistanceConstraint("stuff avoids deer", "deer", 12.0);
	  int deerAvoidDeer=rmCreateTypeDistanceConstraint("deer avoids deer", "deer", 40.0);
   	  	  
      // WATER AVOIDANCE:
	  int avoidWater8 = rmCreateTerrainDistanceConstraint("avoid water", "Land", false, 8.0);
	  	  
	  // DECORATION AVOIDANCE:
      int avoidAll=rmCreateTypeDistanceConstraint("avoid all", "all", 8.0);
	  
	  // FOREST AVOIDANCE:
	  int forestConstraint=rmCreateClassDistanceConstraint("forest vs. forest", rmClassID("classForest"), 12.0);
	   
	  // IMPASSABLE LAND AVOIDANCE:
      int avoidImpassableLand=rmCreateTerrainDistanceConstraint("avoid impassable land", "land", false, 10.0);
       
	  // CLIFFS AVOIDANCE:
	  int avoidCliffs=rmCreateClassDistanceConstraint("stuff vs. cliff", rmClassID("classCliff"), 10.0);
	  int cliffsAvoidCliffs=rmCreateClassDistanceConstraint("cliffs vs. cliffs", rmClassID("classCliff"), 30.0);
      
      // TRADE ROUTE AVOIDANCE:
	  int avoidTradeRoute = rmCreateTradeRouteDistanceConstraint("trade route", 6.0);
	  
	  // SOCKET AVOIDANCE:
	  int avoidSocket = rmCreateClassDistanceConstraint("avoid socket", rmClassID("classSocket"), 10.0);
	  
	  // IMPORTANT AVOIDANCE:
	  int avoidImportantItem = rmCreateClassDistanceConstraint("stuff avoid important stuff", rmClassID("importantItem"), 50.0);
	  	  
	  // CIRCLE CONSTRAINT:
	  int circleConstraint=rmCreatePieConstraint("circle Constraint", 0.5, 0.5, 0, rmZFractionToMeters(0.485), rmDegreesToRadians(0), rmDegreesToRadians(360));
/*================================================================================================================*/
/*================================================================================================================*/	
// ********************************** DEFINE AND PLACE THE 2 TRADE ROUTES: ************************************** //
/*================================================================================================================*/ 
      // DEFINE AND PLACE THE TRADE ROUTE NUMBER 1:
	  int tradeRouteID = rmCreateTradeRoute();
      int socketID=rmCreateObjectDef("sockets to dock Trade Posts south");
      rmSetObjectDefTradeRouteID(socketID, tradeRouteID);

      rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
      rmSetObjectDefAllowOverlap(socketID, true);
      rmAddObjectDefToClass(socketID, rmClassID("classSocket"));
      rmSetObjectDefMinDistance(socketID, 0.0);
      rmSetObjectDefMaxDistance(socketID, 12.0);

	  //rmAddTradeRouteWaypoint(tradeRouteID, 0.8, 0.3);
	  //rmAddTradeRouteWaypoint(tradeRouteID, 0.2, 0.3);
	  rmAddTradeRouteWaypoint(tradeRouteID, 0.23, 0.13);
	  rmAddTradeRouteWaypoint(tradeRouteID, 0.555, 0.20);
	  rmAddTradeRouteWaypoint(tradeRouteID, 0.75, 0.13);
	  //rmAddRandomTradeRouteWaypoints(tradeRouteID, 0.2, 0.3, 10, 4);

      bool placedTradeRoute = rmBuildTradeRoute(tradeRouteID, "dirt");
      if(placedTradeRoute == false)
      rmEchoError("Failed to place trade route"); 
/*================================================================================================================*/  
	  // ADD THE SOCKETS ALONG THE TRADE ROUTE NUMBER 1:
      vector socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.05);
      rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
	  
	  socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.50);
      rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);

      socketLoc = rmGetTradeRouteWayPoint(tradeRouteID, 0.95);
      rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
	  
	  rmClearClosestPointConstraints();
/*================================================================================================================*/
      // DEFINE AND PLACE THE TRADE ROUTE NUMBER 2:
	  int tradeRoute2ID = rmCreateTradeRoute();
      socketID=rmCreateObjectDef("sockets to dock Trade Posts north");
      rmSetObjectDefTradeRouteID(socketID, tradeRoute2ID);

      rmAddObjectDefItem(socketID, "SocketTradeRoute", 1, 0.0);
      rmSetObjectDefAllowOverlap(socketID, true);
      rmAddObjectDefToClass(socketID, rmClassID("classSocket"));
      rmSetObjectDefMinDistance(socketID, 0.0);
      rmSetObjectDefMaxDistance(socketID, 12.0);

	  rmAddTradeRouteWaypoint(tradeRoute2ID, 0.23, 0.88);
	  rmAddTradeRouteWaypoint(tradeRoute2ID, 0.555, 0.80);
	  rmAddTradeRouteWaypoint(tradeRoute2ID, 0.75, 0.88);
	  //rmAddRandomTradeRouteWaypoints(tradeRoute2ID, 0.2, 0.7, 10, 4);

      placedTradeRoute = rmBuildTradeRoute(tradeRoute2ID, "dirt");
      if(placedTradeRoute == false)
      rmEchoError("Failed to place trade route"); 
/*================================================================================================================*/  
	  // ADD THE SOCKETS ALONG THE TRADE ROUTE NUMBER 2:
      socketLoc = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.05);
      rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
	  
	  socketLoc = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.50);
      rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);

      socketLoc = rmGetTradeRouteWayPoint(tradeRoute2ID, 0.95);
      rmPlaceObjectDefAtPoint(socketID, 0, socketLoc);
	  
	  rmClearClosestPointConstraints();
/*================================================================================================================*/
// ********************************** SET UP THE PLAYER STARTING LOCATIONS: ************************************* //
/*================================================================================================================*/
   // SET UP PLAYER STARTING LOCATIONS:
   if ( cNumberTeams <= 2 )
   {
	   rmSetPlacementSection(0.7, 0.3); // 0.5
   }
   else
   {
	   rmSetPlacementSection(0.2, 0.8); // 0.5	   	
   }
   rmSetTeamSpacingModifier(0.7);
   rmPlacePlayersCircular(0.38, 0.38, 0);
/*================================================================================================================*/

/*================================================================================================================*/
// ****************************************** SET UP THE PLAYER AREAS: ****************************************** //
/*================================================================================================================*/
   float playerFraction=rmAreaTilesToFraction(100);
/*----------------------------------------------------------------------------------------------------------------*/   
   for(i=1; <cNumberPlayers)
/*----------------------------------------------------------------------------------------------------------------*/   
   {
      // CREATE THE AREA:
      int id=rmCreateArea("Player"+i);
      
	  // ASSIGN TO THE PLAYER:
      rmSetPlayerArea(i, id);
      
	  // SET THE SIZE:
      rmSetAreaSize(id, playerFraction, playerFraction);
      
	  // ADD AREA TO CLASS:
	  rmAddAreaToClass(id, classPlayer);
      
	  // SET THE BLOBS:
	  rmSetAreaMinBlobs(id, 1);
      rmSetAreaMaxBlobs(id, 1);
      
	  // ADD AREA CONSTRAINTS:
	  rmAddAreaConstraint(id, playerConstraint); 
      rmAddAreaConstraint(id, playerEdgeConstraint); 
	  rmAddAreaConstraint(id, avoidTradeRoute); 
      
	  // SET AREA LOC PLAYER:
	  rmSetAreaLocPlayer(id, i);
	  
	  // SET TYPE:
	  rmSetAreaTerrainType(id, "yukon\ground1_yuk");
	  rmSetAreaMix(id, "great plains drygrass"); // FROM GREAT PLAINS:
	  //rmSetAreaMix(id, "great plains grass"); // FROM GREAT PLAINS:
	        
	  // SET AREA WARN FAILURE:
	  rmSetAreaWarnFailure(id, false);
   }
/*----------------------------------------------------------------------------------------------------------------*/
      // BUILD AREA:
	  rmBuildArea(id);   
/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE CENTER LAKE: *************************************** //       
/*================================================================================================================*/
            int lakeClass=rmDefineClass("lake");
	        int lakeConstraint=rmCreateClassDistanceConstraint("lake vs. lake", rmClassID("lake"), 20.0);

			int smallLakeID=rmCreateArea("small lake");
			rmSetAreaSize(smallLakeID, rmAreaTilesToFraction(4000), rmAreaTilesToFraction(4000));
			rmSetAreaWaterType(smallLakeID, "new england lake");
			rmSetAreaBaseHeight(smallLakeID, 2.0);
			rmAddAreaToClass(smallLakeID, lakeClass);
			rmAddAreaConstraint(smallLakeID, playerConstraint);
			rmAddAreaConstraint(smallLakeID, avoidTradeRoute);
			rmSetAreaCoherence(smallLakeID, 0.3);
			rmSetAreaWarnFailure(smallLakeID, false);
			rmSetAreaLocation(smallLakeID, 0.5, 0.5);
			rmBuildArea(smallLakeID);	
/*================================================================================================================*/
            rmClearClosestPointConstraints();
/*================================================================================================================*/
// **************************** DEFINE THE STARTING TCID AND THE STARTING UNITS: ******************************** //
/*================================================================================================================*/
	int startingUnits = rmCreateStartingUnitsObjectDef(5.0);
	rmSetObjectDefMinDistance(startingUnits, 5.0);
	rmSetObjectDefMaxDistance(startingUnits, 10.0);
	rmAddObjectDefToClass(startingUnits, rmClassID("startingUnit"));
	rmAddObjectDefConstraint(startingUnits, avoidAll);

	int startingTCID =  rmCreateObjectDef("startingTC");
	if ( rmGetNomadStart())
	{
		rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
	}
	else
	{
		rmAddObjectDefItem(startingTCID, "CoveredWagon", 1, 0.0);
	}
	rmAddObjectDefToClass(startingTCID, rmClassID("startingUnit"));
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.60);
/*================================================================================================================*/
// ************************************* DEFINE THE STARTING RESOURCES: ***************************************** //
/*================================================================================================================*/
	// DEFINE THE STARTING SILVER MINES:
	int silverType = -1;
	int playerGoldID = -1;

	// DEFINE THE STARTING TREES:
	int StartAreaTreeID = rmCreateObjectDef("starting trees");
	rmAddObjectDefItem(StartAreaTreeID, "TreeNewEngland", 1, 0.0);
	rmSetObjectDefMinDistance(StartAreaTreeID, 10.0);
	rmSetObjectDefMaxDistance(StartAreaTreeID, 15.0);
	rmAddObjectDefConstraint(StartAreaTreeID, avoidStartingUnitsSmall);

	// DEFINE THE STARTING BERRYBUSH:
	int StartBerryBushID = rmCreateObjectDef("starting BerryBush");
	rmAddObjectDefItem(StartBerryBushID, "BerryBush", 3, 5.0);
	rmSetObjectDefMinDistance(StartBerryBushID, 10.0);
	rmSetObjectDefMaxDistance(StartBerryBushID, 15.0);
	rmAddObjectDefConstraint(StartBerryBushID, avoidStartingUnitsSmall);

	// DEFINE THE PLAYER NUGGET:
	int playerNuggetID = rmCreateObjectDef("player nugget");
	rmAddObjectDefItem(playerNuggetID, "nugget", 1, 0.0);
	rmAddObjectDefToClass(playerNuggetID, rmClassID("classNugget"));
    rmSetObjectDefMinDistance(playerNuggetID, 30.0);
    rmSetObjectDefMaxDistance(playerNuggetID, 35.0);
	rmAddObjectDefConstraint(playerNuggetID, avoidStartingUnitsSmall);
	rmAddObjectDefConstraint(playerNuggetID, avoidNugget);
	rmAddObjectDefConstraint(playerNuggetID, circleConstraint);

	// DEFINE THE WATER FLAG:
	int waterFlagID = -1;
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERAYION PROGRESS BAR:
   rmSetStatusText("",0.65);
/*================================================================================================================*/
// ****************************** PLACE THE STARTING TCID AND THE STARTING UNITS: ******************************* //
/*================================================================================================================*/
    	for(i = 1; <cNumberPlayers)
/*----------------------------------------------------------------------------------------------------------------*/		
	{
/*----------------------------------------------------------------------------------------------------------------*/	
		rmClearClosestPointConstraints();
/*----------------------------------------------------------------------------------------------------------------*/		
		// PLACE THE STARTING TCID AND STARTING UNITS:
		rmPlaceObjectDefAtLoc(startingTCID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(startingUnits, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
/*================================================================================================================*/
// ************************************** PLACE THE STARTING RESOURCES: ***************************************** //
/*================================================================================================================*/
		// EVERYONE GETS ONE ORE GROUPING CLOSE BY:
		silverType = rmRandInt(1,10);
		playerGoldID = rmCreateObjectDef("player silver closer "+i);
		rmAddObjectDefItem(playerGoldID, "mine", 1, 0.0);
		rmAddObjectDefConstraint(playerGoldID, avoidTradeRoute);
		rmAddObjectDefConstraint(playerGoldID, avoidStartingUnitsSmall);
		rmSetObjectDefMinDistance(playerGoldID, 15.0);
		rmSetObjectDefMaxDistance(playerGoldID, 20.0);
		rmPlaceObjectDefAtLoc(playerGoldID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

        // PLACING THE STARTING BERRYBUSH:
		rmPlaceObjectDefAtLoc(StartBerryBushID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		
		// PLACING THE STARTING TREES:
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(StartAreaTreeID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// PLACING THE PLAYER NUGGETS:
		rmSetNuggetDifficulty(1, 1);
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
		rmPlaceObjectDefAtLoc(playerNuggetID, 0, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));

		// PLACING THE WATER FLAG:
		waterFlagID = rmCreateObjectDef("HC water flag "+i);
		rmAddObjectDefItem(waterFlagID, "HomeCityWaterSpawnFlag", 1, 0.0);
		rmAddClosestPointConstraint(flagEdgeConstraint);
		rmAddClosestPointConstraint(flagVsFlag);
		rmAddClosestPointConstraint(flagLand);
		vector TCLocation = rmGetUnitPosition(rmGetUnitPlacedOfPlayer(startingTCID, i));
        vector closestPoint = rmFindClosestPointVector(TCLocation, rmXFractionToMeters(1.0));
		rmPlaceObjectDefAtLoc(waterFlagID, i, rmXMetersToFraction(xsVectorGetX(closestPoint)), rmZMetersToFraction(xsVectorGetZ(closestPoint)));
		rmClearClosestPointConstraints();
/*----------------------------------------------------------------------------------------------------------------*/
   }
/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE NATIVES TRIBES: ************************************ //
/*================================================================================================================*/
   int nativeChoice = rmRandInt(1,2);
   int villageAID = -1;
   int villageType = rmRandInt(1,3);

   if (nativeChoice == 1)
	villageAID = rmCreateGrouping("village A", "native cree village "+villageType);
   else if (nativeChoice == 2)
	// villageAID = rmCreateGrouping("village A", "native comanche village "+villageType);
	   villageAID = rmCreateGrouping("village A", "native cree village "+villageType);
   // rmSetGroupingMinDistance(villageAID, 25.0);
   // rmSetGroupingMaxDistance(villageAID, 90.0);
      rmSetGroupingMinDistance(villageAID, 45.0);
      rmSetGroupingMaxDistance(villageAID, 90.0);
   rmAddGroupingToClass(villageAID, rmClassID("natives"));
   rmAddGroupingToClass(villageAID, rmClassID("importantItem"));
   rmAddGroupingConstraint(villageAID, avoidImpassableLand);
   rmAddGroupingConstraint(villageAID, avoidTradeRoute);
   rmAddGroupingConstraint(villageAID, avoidImportantItem);
   rmAddGroupingConstraint(villageAID, avoidNatives);
   rmAddGroupingConstraint(villageAID, lakeConstraint);

   for(i=1; <cNumberPlayers)
   {
	rmPlaceGroupingAtLoc(villageAID, i, rmPlayerLocXFraction(i), rmPlayerLocZFraction(i));
   }
/*================================================================================================================*/
/*================================================================================================================*/
// **************************************** DEFINE AND PLACE THE FORESTS: *************************************** //
/*================================================================================================================*/
	  int forestTreeID = 0;
      int numTries=7*cNumberNonGaiaPlayers;
      if (cNumberNonGaiaPlayers == 3)
      numTries=6*cNumberNonGaiaPlayers;
      if (cNumberNonGaiaPlayers > 3)
      numTries=5*cNumberNonGaiaPlayers;
      int failCount=0;
   
       for (i=0; <numTries)
	   
	/*    int forestTreeID = 0;
        int numTries=5*cNumberNonGaiaPlayers;
        int failCount=0;
        for (i=0; <numTries)  */ 
   {  
      int forest=rmCreateArea("forest "+i);
      rmSetAreaWarnFailure(forest, false);
      rmSetAreaSize(forest, rmAreaTilesToFraction(220), rmAreaTilesToFraction(400));
      rmSetAreaForestType(forest, "new england forest");
      rmSetAreaForestDensity(forest, 0.8);
      rmSetAreaForestClumpiness(forest, rmRandFloat(0.5,0.8));
      rmSetAreaForestUnderbrush(forest, 0.0);
      rmSetAreaMinBlobs(forest, 1);
      rmSetAreaMaxBlobs(forest, 3);
      rmSetAreaMinBlobDistance(forest, 16.0);
      rmSetAreaMaxBlobDistance(forest, 70.0);
      rmSetAreaCoherence(forest, 0.4);
      rmSetAreaSmoothDistance(forest, 0);
      rmAddAreaToClass(forest, rmClassID("classForest")); 
      rmAddAreaConstraint(forest, forestConstraint);
      rmAddAreaConstraint(forest, avoidNugget);
	  rmAddAreaConstraint(forest, avoidDeer);
	  rmAddAreaConstraint(forest, avoidAll);
	  rmAddAreaConstraint(forest, playerConstraint);
	  rmAddAreaConstraint(forest, lakeConstraint);
      rmAddAreaConstraint(forest, playerEdgeConstraint);
      rmAddAreaConstraint(forest, avoidFruits); 
	  rmAddAreaConstraint(forest, avoidTradeRoute); 
	  rmAddAreaConstraint(forest, avoidSocket); 
      rmAddAreaConstraint(forest, avoidImpassableLand); 
      rmAddAreaConstraint(forest, avoidNatives);
      rmAddAreaConstraint(forest, avoidCoin);
      if(rmBuildArea(forest)==false)
      {
         // Stop trying once we fail 3 times in a row.
         failCount++;
         if(failCount==5)
            break;
      }
      else
         failCount=0; 
   }		
/*================================================================================================================*/
/*================================================================================================================*/
// ************************************ DEFINE AND PLACE THE RANDOM TREES: ************************************** //
/*================================================================================================================*/
      // DEFINE AND PLACE THE RANDOM TREES:
      int StragglerTreeID=rmCreateObjectDef("stragglers");
      rmAddObjectDefItem(StragglerTreeID, "TreeNewEngland", 1, 0.0);
      rmAddObjectDefConstraint(StragglerTreeID, avoidAll);
	  rmAddObjectDefConstraint(StragglerTreeID, avoidNugget);
	  rmAddObjectDefConstraint(StragglerTreeID, avoidDeer);
	  rmAddObjectDefConstraint(StragglerTreeID, avoidTradeRoute);
	  rmAddObjectDefConstraint(StragglerTreeID, avoidSocket);
	  rmAddObjectDefConstraint(StragglerTreeID, avoidSheep);
	  //rmAddObjectDefConstraint(StragglerTreeID, avoidNugget);
      rmAddObjectDefConstraint(StragglerTreeID, avoidStartingUnits);
      rmAddObjectDefConstraint(StragglerTreeID, playerConstraint);
      rmAddObjectDefConstraint(StragglerTreeID, playerEdgeConstraint);
      rmAddObjectDefConstraint(StragglerTreeID, avoidNatives);
      rmAddObjectDefConstraint(StragglerTreeID, lakeConstraint);
	  rmAddObjectDefConstraint(StragglerTreeID, avoidCoin);
      rmSetObjectDefMinDistance(StragglerTreeID, 0.0);
      rmSetObjectDefMaxDistance(StragglerTreeID, rmXFractionToMeters(0.5));
      for(i=0; <cNumberNonGaiaPlayers*25)
      rmPlaceObjectDefAtLoc(StragglerTreeID, 0, 0.5, 0.5);
/*================================================================================================================*/
/*================================================================================================================*/
// ******************************** DEFINING AND CREATING THE RANDOM NUGGETS: *********************************** //
/*================================================================================================================*/
   // RANDOM NUGGETS:
   int nugget1ID= rmCreateObjectDef("nugget 1"); 
   rmAddObjectDefItem(nugget1ID, "Nugget", 1, 0.0);
   rmAddObjectDefToClass(nugget1ID, rmClassID("classNugget"));
   rmSetObjectDefMinDistance(nugget1ID, 45.0);
   rmSetObjectDefMaxDistance(nugget1ID, rmXFractionToMeters(0.35));
   rmAddObjectDefConstraint(nugget1ID, avoidImpassableLand);
   rmAddObjectDefConstraint(nugget1ID, avoidNugget);
   rmAddObjectDefConstraint(nugget1ID, nuggetAvoidNugget);
   rmAddObjectDefConstraint(nugget1ID, avoidStartingUnits);
   rmAddObjectDefConstraint(nugget1ID, avoidNatives);
   rmAddObjectDefConstraint(nugget1ID, avoidCoin);
   rmAddObjectDefConstraint(nugget1ID, avoidAll);
   rmAddObjectDefConstraint(nugget1ID, avoidTradeRoute);
   rmAddObjectDefConstraint(nugget1ID, avoidSocket);
   rmAddObjectDefConstraint(nugget1ID, playerConstraint);
   rmAddObjectDefConstraint(nugget1ID, playerEdgeConstraint);
   //rmAddObjectDefConstraint(nugget1ID, circleConstraint);
   rmAddObjectDefConstraint(nugget1ID, lakeConstraint);
   rmPlaceObjectDefAtLoc(nugget1ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*4);
/*================================================================================================================*/

/*================================================================================================================*/
/*================================================================================================================*/		
// ********************************** DEFINE AND PLACE THE BERRY BUSHES: **************************************** //
/*================================================================================================================*/
      int RandomBerriesID=rmCreateObjectDef("Random Berries");
      rmAddObjectDefItem(RandomBerriesID, "berrybush", rmRandInt(3,5), 6.0);
      rmSetObjectDefMinDistance(RandomBerriesID, 0.0);
      rmSetObjectDefMaxDistance(RandomBerriesID, rmXFractionToMeters(0.5));
	  rmAddObjectDefConstraint(RandomBerriesID, avoidDeer);
      rmAddObjectDefConstraint(RandomBerriesID, avoidSheep);
	  rmAddObjectDefConstraint(RandomBerriesID, avoidAll);
	  rmAddObjectDefConstraint(RandomBerriesID, avoidTradeRoute);
      rmAddObjectDefConstraint(RandomBerriesID, avoidSocket);
	  rmAddObjectDefConstraint(RandomBerriesID, avoidFruits);
	  rmAddObjectDefConstraint(RandomBerriesID, fruitsAvoidFruits);
	  rmAddObjectDefConstraint(RandomBerriesID, playerEdgeConstraint);
	  rmAddObjectDefConstraint(RandomBerriesID, avoidCoin);
	  rmAddObjectDefConstraint(RandomBerriesID, avoidNugget);
	  rmAddObjectDefConstraint(RandomBerriesID, playerConstraint);
	  rmAddObjectDefConstraint(RandomBerriesID, avoidNatives);
      rmAddObjectDefConstraint(RandomBerriesID, avoidImpassableLand);
	  rmPlaceObjectDefAtLoc(RandomBerriesID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*3);    
/*================================================================================================================*/
/*================================================================================================================*/
// ************************************** DEFINE AND PLACE SILVER MINES 1: ************************************** //
/*================================================================================================================*/
	  silverType = rmRandInt(1,10);
	  int silverID = rmCreateObjectDef("silver 1");
	  rmAddObjectDefItem(silverID, "mine", 1, 0.0);
	  rmSetObjectDefMinDistance(silverID, 0.0);
	  rmSetObjectDefMaxDistance(silverID, rmXFractionToMeters(0.5));
	  rmAddObjectDefConstraint(silverID, avoidCoin); // STUFF AVOID A MINE BY A DISTANCE OF 10:
	  rmAddObjectDefConstraint(silverID, coinAvoidCoin); // DISTANCE OF 35 BETWEEN EACH SILVER MINE:
	  rmAddObjectDefConstraint(silverID, avoidAll);
	  rmAddObjectDefConstraint(silverID, playerConstraint); // MINE AVOID PLAYER BY 30:
	  rmAddObjectDefConstraint(silverID, lakeConstraint);  // MINE AVOID LAKE BY 30:
	  rmAddObjectDefConstraint(silverID, avoidImpassableLand);
	  rmAddObjectDefConstraint(silverID, avoidTradeRoute);
	  rmAddObjectDefConstraint(silverID, avoidSocket);
	  rmAddObjectDefConstraint(silverID, playerEdgeConstraint); // MINE DISTANCE OF 10 FROM THE EDGE OF THE MAP:
	  rmAddObjectDefConstraint(silverID, Westward); // THREE MINES ON THE WEST SIDE OF THE MAP:
	  rmAddObjectDefConstraint(silverID, avoidStartingUnits);
	  rmPlaceObjectDefAtLoc(silverID, 0, 0.5, 0.5, 5.0); // THREE MINES: DISTANCE OF 35 BETWEEN EACH OTHER:
/*================================================================================================================*/
// ************************************** DEFINE AND PLACE SILVER MINES 2: ************************************** //
/*================================================================================================================*/
	  silverType = rmRandInt(1,10);
	  int silver2ID = rmCreateObjectDef("silver 2");
	  rmAddObjectDefItem(silver2ID, "mine", 1, 0.0);
	  rmSetObjectDefMinDistance(silver2ID, 0.0);
	  rmSetObjectDefMaxDistance(silver2ID, rmXFractionToMeters(0.5));
	  rmAddObjectDefConstraint(silver2ID, avoidCoin); // STUFF AVOID A MINE BY A DISTANCE OF 10:
	  rmAddObjectDefConstraint(silver2ID, coinAvoidCoin); // DISTANCE OF 35 BETWEEN EACH SILVER MINE:
	  rmAddObjectDefConstraint(silver2ID, avoidAll);
	  rmAddObjectDefConstraint(silver2ID, playerConstraint); // MINE AVOID PLAYER BY 30:
	  rmAddObjectDefConstraint(silver2ID, lakeConstraint);  // MINE AVOID LAKE BY 30:
	  rmAddObjectDefConstraint(silver2ID, avoidImpassableLand);
	  rmAddObjectDefConstraint(silver2ID, avoidTradeRoute);
	  rmAddObjectDefConstraint(silver2ID, avoidSocket);
	  rmAddObjectDefConstraint(silver2ID, playerEdgeConstraint); // MINE DISTANCE OF 10 FROM THE EDGE OF THE MAP:
	  rmAddObjectDefConstraint(silver2ID, Eastward); // THREE MINES ON THE EAST SIDE OF THE MAP:
	  rmAddObjectDefConstraint(silver2ID, avoidStartingUnits);
	  rmPlaceObjectDefAtLoc(silver2ID, 0, 0.5, 0.5, 5.0); // THREE MINES: DISTANCE OF 35 BETWEEN EACH OTHER:
/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE SHEEPS: ***************************************** //
/*================================================================================================================*/
      int sheepID=rmCreateObjectDef("herdable animal 1");
      rmAddObjectDefItem(sheepID, "sheep", rmRandInt(2,4), 6.0);
      rmSetObjectDefMinDistance(sheepID, 0.0);
      rmSetObjectDefMaxDistance(sheepID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(sheepID, avoidSheep);
	  rmAddObjectDefConstraint(sheepID, sheepAvoidSheep);
      rmAddObjectDefConstraint(sheepID, avoidAll);
	  rmAddObjectDefConstraint(sheepID, lakeConstraint);
	  rmAddObjectDefConstraint(sheepID, avoidNugget);
	  rmAddObjectDefConstraint(sheepID, avoidTradeRoute);
	  rmAddObjectDefConstraint(sheepID, avoidSocket);
	  rmAddObjectDefConstraint(sheepID, avoidCoin);
	  rmAddObjectDefConstraint(sheepID, Westward);
	  rmAddObjectDefConstraint(sheepID, avoidFruits);
      rmAddObjectDefConstraint(sheepID, playerConstraint);
      rmAddObjectDefConstraint(sheepID, playerEdgeConstraint);
      rmAddObjectDefConstraint(sheepID, avoidImpassableLand);
      rmPlaceObjectDefAtLoc(sheepID, 0, 0.5, 0.5, cNumberNonGaiaPlayers);
/*================================================================================================================*/
      int sheep2ID=rmCreateObjectDef("herdable animal 2");
      rmAddObjectDefItem(sheep2ID, "sheep", rmRandInt(2,4), 6.0);
      rmSetObjectDefMinDistance(sheep2ID, 0.0);
      rmSetObjectDefMaxDistance(sheep2ID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(sheep2ID, avoidSheep);
	  rmAddObjectDefConstraint(sheep2ID, sheepAvoidSheep);
      rmAddObjectDefConstraint(sheep2ID, avoidAll);
	  rmAddObjectDefConstraint(sheep2ID, lakeConstraint);
	  rmAddObjectDefConstraint(sheep2ID, avoidNugget);
	  rmAddObjectDefConstraint(sheep2ID, avoidTradeRoute);
	  rmAddObjectDefConstraint(sheep2ID, avoidSocket);
	  rmAddObjectDefConstraint(sheep2ID, avoidCoin);
	  rmAddObjectDefConstraint(sheep2ID, Eastward);
	  rmAddObjectDefConstraint(sheep2ID, avoidFruits);
      rmAddObjectDefConstraint(sheep2ID, playerConstraint);
      rmAddObjectDefConstraint(sheep2ID, playerEdgeConstraint);
      rmAddObjectDefConstraint(sheep2ID, avoidImpassableLand);
      rmPlaceObjectDefAtLoc(sheep2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers); 
/*================================================================================================================*/
/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE DEERS: ****************************************** //
/*================================================================================================================*/
      int deerID=rmCreateObjectDef("herdable deer 1");
      rmAddObjectDefItem(deerID, "deer", rmRandInt(5,7), 8.0);
      rmSetObjectDefMinDistance(deerID, 0.0);
      rmSetObjectDefMaxDistance(deerID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(deerID, avoidSheep);
	  rmAddObjectDefConstraint(deerID, avoidDeer);
	  rmAddObjectDefConstraint(deerID, deerAvoidDeer);
      rmAddObjectDefConstraint(deerID, avoidAll);
	  rmAddObjectDefConstraint(deerID, lakeConstraint);
	  rmAddObjectDefConstraint(deerID, avoidNugget);
	  rmAddObjectDefConstraint(deerID, avoidTradeRoute);
	  rmAddObjectDefConstraint(deerID, avoidSocket);
	  rmAddObjectDefConstraint(deerID, avoidCoin);
	  rmAddObjectDefConstraint(deerID, Westward);
	  rmAddObjectDefConstraint(deerID, avoidFruits);
      rmAddObjectDefConstraint(deerID, playerConstraint);
      rmAddObjectDefConstraint(deerID, playerEdgeConstraint);
      rmAddObjectDefConstraint(deerID, avoidImpassableLand);
      rmPlaceObjectDefAtLoc(deerID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);	
/*================================================================================================================*/
      int deer2ID=rmCreateObjectDef("herdable deer 2");
      rmAddObjectDefItem(deer2ID, "deer", rmRandInt(5,7), 8.0);
      rmSetObjectDefMinDistance(deer2ID, 0.0);
      rmSetObjectDefMaxDistance(deer2ID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(deer2ID, avoidSheep);
	  rmAddObjectDefConstraint(deer2ID, avoidDeer);
	  rmAddObjectDefConstraint(deer2ID, deerAvoidDeer);
      rmAddObjectDefConstraint(deer2ID, avoidAll);
	  rmAddObjectDefConstraint(deer2ID, lakeConstraint);
	  rmAddObjectDefConstraint(deer2ID, avoidNugget);
	  rmAddObjectDefConstraint(deer2ID, avoidTradeRoute);
	  rmAddObjectDefConstraint(deer2ID, avoidSocket);
	  rmAddObjectDefConstraint(deer2ID, avoidCoin);
	  rmAddObjectDefConstraint(deer2ID, Eastward);
	  rmAddObjectDefConstraint(deer2ID, avoidFruits);
      rmAddObjectDefConstraint(deer2ID, playerConstraint);
      rmAddObjectDefConstraint(deer2ID, playerEdgeConstraint);
      rmAddObjectDefConstraint(deer2ID, avoidImpassableLand);
      rmPlaceObjectDefAtLoc(deer2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers*2);	
/*================================================================================================================*/
/*================================================================================================================*/
// *************************************** DEFINE AND PLACE THE BISONS: ***************************************** //	
/*================================================================================================================*/
      int bisonID=rmCreateObjectDef("bison herd 1");
      rmAddObjectDefItem(bisonID, "bison", rmRandInt(12,16), 12.0);
      rmSetObjectDefMinDistance(bisonID, 0.0);
      rmSetObjectDefMaxDistance(bisonID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(bisonID, avoidBison);
	  rmAddObjectDefConstraint(bisonID, bisonAvoidBison);
	  rmAddObjectDefConstraint(bisonID, avoidAll);
	  rmAddObjectDefConstraint(bisonID, avoidDeer);
	  rmAddObjectDefConstraint(bisonID, avoidSheep);
	  rmAddObjectDefConstraint(bisonID, avoidFruits);
	  rmAddObjectDefConstraint(bisonID, avoidCoin);
      rmAddObjectDefConstraint(bisonID, avoidImpassableLand);
	  rmAddObjectDefConstraint(bisonID, avoidTradeRoute);
	  rmAddObjectDefConstraint(bisonID, avoidSocket);
	  rmAddObjectDefConstraint(bisonID, playerConstraint);
	  rmAddObjectDefConstraint(bisonID, playerEdgeConstraint);
	  rmAddObjectDefConstraint(bisonID, Northward);
      rmSetObjectDefCreateHerd(bisonID, true);
	  rmPlaceObjectDefAtLoc(bisonID, 0, 0.5, 0.5, cNumberNonGaiaPlayers);
/*================================================================================================================*/
      int bison2ID=rmCreateObjectDef("bison herd 2");
      rmAddObjectDefItem(bison2ID, "bison", rmRandInt(12,16), 12.0);
      rmSetObjectDefMinDistance(bison2ID, 0.0);
      rmSetObjectDefMaxDistance(bison2ID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(bison2ID, avoidBison);
	  rmAddObjectDefConstraint(bison2ID, bisonAvoidBison);
	  rmAddObjectDefConstraint(bison2ID, avoidAll);
	  rmAddObjectDefConstraint(bison2ID, avoidDeer);
	  rmAddObjectDefConstraint(bison2ID, avoidSheep);
	  rmAddObjectDefConstraint(bison2ID, avoidFruits);
	  rmAddObjectDefConstraint(bison2ID, avoidCoin);
      rmAddObjectDefConstraint(bison2ID, avoidImpassableLand);
	  rmAddObjectDefConstraint(bison2ID, avoidTradeRoute);
	  rmAddObjectDefConstraint(bison2ID, avoidSocket);
	  rmAddObjectDefConstraint(bison2ID, playerConstraint);
	  rmAddObjectDefConstraint(bison2ID, playerEdgeConstraint);
	  rmAddObjectDefConstraint(bison2ID, Southward);
      rmSetObjectDefCreateHerd(bison2ID, true);
	  rmPlaceObjectDefAtLoc(bison2ID, 0, 0.5, 0.5, cNumberNonGaiaPlayers);
/*================================================================================================================*/
// ************************************** DEFINE AND PLACE THE FISHES: ****************************************** //
/*================================================================================================================*/
      // FISHES:
      int fishID=rmCreateObjectDef("fish");
      int fishVsFishID=rmCreateTypeDistanceConstraint("fish v fish", "fish", 12.0);
      int fishLand = rmCreateTerrainDistanceConstraint("fish land", "land", true, 6.0);
      // rmAddObjectDefItem(fishID, "FishBass", 1, 0.0);
         rmAddObjectDefItem(fishID, "FishBass", 3, 6.0);
      rmSetObjectDefMinDistance(fishID, 0.0);
      rmSetObjectDefMaxDistance(fishID, rmXFractionToMeters(0.5));
      rmAddObjectDefConstraint(fishID, fishVsFishID);
      rmAddObjectDefConstraint(fishID, fishLand);
      if (cNumberNonGaiaPlayers < 4)
      // rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, rmRandInt(3,5));
	     rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, rmRandInt(15,25));
      else
	  // rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, rmRandInt(4,6));
	     rmPlaceObjectDefAtLoc(fishID, 0, 0.5, 0.5, rmRandInt(15,25));
/*================================================================================================================*/ 	  
/*================================================================================================================*/
   // TEXT:
   // THESE STATUS TEXT LINES ARE USED TO MANUALLY ANIMATE THE MAP GENERATION PROGRESS BAR:
   rmSetStatusText("",1.00);
/*================================================================================================================*/   
}  
/*----------------------------------------------------------------------------------------------------------------*/
// ************************************** THIS IS THE END OF THE MAP: ******************************************* //
/*----------------------------------------------------------------------------------------------------------------*/